/*
 * Decompiled with CFR 0.152.
 */
package org.python.antlr.runtime.debug;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import org.python.antlr.runtime.BaseRecognizer;
import org.python.antlr.runtime.RecognitionException;
import org.python.antlr.runtime.Token;
import org.python.antlr.runtime.debug.BlankDebugEventListener;
import org.python.antlr.runtime.tree.TreeAdaptor;

public class DebugEventSocketProxy
extends BlankDebugEventListener {
    public static final int DEFAULT_DEBUGGER_PORT = 49100;
    protected int port = 49100;
    protected ServerSocket serverSocket;
    protected Socket socket;
    protected String grammarFileName;
    protected PrintWriter out;
    protected BufferedReader in;
    protected BaseRecognizer recognizer;
    protected TreeAdaptor adaptor;

    public DebugEventSocketProxy(BaseRecognizer baseRecognizer, TreeAdaptor treeAdaptor) {
        this(baseRecognizer, 49100, treeAdaptor);
    }

    public DebugEventSocketProxy(BaseRecognizer baseRecognizer, int n, TreeAdaptor treeAdaptor) {
        this.grammarFileName = baseRecognizer.getGrammarFileName();
        this.adaptor = treeAdaptor;
        this.port = n;
    }

    public void handshake() throws IOException {
        if (this.serverSocket == null) {
            this.serverSocket = new ServerSocket(this.port);
            this.socket = this.serverSocket.accept();
            this.socket.setTcpNoDelay(true);
            OutputStream outputStream = this.socket.getOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF8");
            this.out = new PrintWriter(new BufferedWriter(outputStreamWriter));
            InputStream inputStream = this.socket.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF8");
            this.in = new BufferedReader(inputStreamReader);
            this.out.println("ANTLR 2");
            this.out.println("grammar \"" + this.grammarFileName);
            this.out.flush();
            this.ack();
        }
    }

    public void commence() {
    }

    public void terminate() {
        this.transmit("terminate");
        this.out.close();
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
    }

    protected void ack() {
        try {
            this.in.readLine();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
    }

    protected void transmit(String string) {
        this.out.println(string);
        this.out.flush();
        this.ack();
    }

    public void enterRule(String string, String string2) {
        this.transmit("enterRule\t" + string + "\t" + string2);
    }

    public void enterAlt(int n) {
        this.transmit("enterAlt\t" + n);
    }

    public void exitRule(String string, String string2) {
        this.transmit("exitRule\t" + string + "\t" + string2);
    }

    public void enterSubRule(int n) {
        this.transmit("enterSubRule\t" + n);
    }

    public void exitSubRule(int n) {
        this.transmit("exitSubRule\t" + n);
    }

    public void enterDecision(int n) {
        this.transmit("enterDecision\t" + n);
    }

    public void exitDecision(int n) {
        this.transmit("exitDecision\t" + n);
    }

    public void consumeToken(Token token) {
        String string = this.serializeToken(token);
        this.transmit("consumeToken\t" + string);
    }

    public void consumeHiddenToken(Token token) {
        String string = this.serializeToken(token);
        this.transmit("consumeHiddenToken\t" + string);
    }

    public void LT(int n, Token token) {
        if (token != null) {
            this.transmit("LT\t" + n + "\t" + this.serializeToken(token));
        }
    }

    public void mark(int n) {
        this.transmit("mark\t" + n);
    }

    public void rewind(int n) {
        this.transmit("rewind\t" + n);
    }

    public void rewind() {
        this.transmit("rewind");
    }

    public void beginBacktrack(int n) {
        this.transmit("beginBacktrack\t" + n);
    }

    public void endBacktrack(int n, boolean bl) {
        this.transmit("endBacktrack\t" + n + "\t" + (bl ? 1 : 0));
    }

    public void location(int n, int n2) {
        this.transmit("location\t" + n + "\t" + n2);
    }

    public void recognitionException(RecognitionException recognitionException) {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("exception\t");
        stringBuffer.append(recognitionException.getClass().getName());
        stringBuffer.append("\t");
        stringBuffer.append(recognitionException.index);
        stringBuffer.append("\t");
        stringBuffer.append(recognitionException.line);
        stringBuffer.append("\t");
        stringBuffer.append(recognitionException.charPositionInLine);
        this.transmit(stringBuffer.toString());
    }

    public void beginResync() {
        this.transmit("beginResync");
    }

    public void endResync() {
        this.transmit("endResync");
    }

    public void semanticPredicate(boolean bl, String string) {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("semanticPredicate\t");
        stringBuffer.append(bl);
        this.serializeText(stringBuffer, string);
        this.transmit(stringBuffer.toString());
    }

    public void consumeNode(Object object) {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("consumeNode");
        this.serializeNode(stringBuffer, object);
        this.transmit(stringBuffer.toString());
    }

    public void LT(int n, Object object) {
        int n2 = this.adaptor.getUniqueID(object);
        String string = this.adaptor.getText(object);
        int n3 = this.adaptor.getType(object);
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("LN\t");
        stringBuffer.append(n);
        this.serializeNode(stringBuffer, object);
        this.transmit(stringBuffer.toString());
    }

    protected void serializeNode(StringBuffer stringBuffer, Object object) {
        int n = this.adaptor.getUniqueID(object);
        String string = this.adaptor.getText(object);
        int n2 = this.adaptor.getType(object);
        stringBuffer.append("\t");
        stringBuffer.append(n);
        stringBuffer.append("\t");
        stringBuffer.append(n2);
        Token token = this.adaptor.getToken(object);
        int n3 = -1;
        int n4 = -1;
        if (token != null) {
            n3 = token.getLine();
            n4 = token.getCharPositionInLine();
        }
        stringBuffer.append("\t");
        stringBuffer.append(n3);
        stringBuffer.append("\t");
        stringBuffer.append(n4);
        int n5 = this.adaptor.getTokenStartIndex(object);
        stringBuffer.append("\t");
        stringBuffer.append(n5);
        this.serializeText(stringBuffer, string);
    }

    public void nilNode(Object object) {
        int n = this.adaptor.getUniqueID(object);
        this.transmit("nilNode\t" + n);
    }

    public void errorNode(Object object) {
        int n = this.adaptor.getUniqueID(object);
        String string = object.toString();
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("errorNode\t");
        stringBuffer.append(n);
        stringBuffer.append("\t");
        stringBuffer.append(0);
        this.serializeText(stringBuffer, string);
        this.transmit(stringBuffer.toString());
    }

    public void createNode(Object object) {
        int n = this.adaptor.getUniqueID(object);
        String string = this.adaptor.getText(object);
        int n2 = this.adaptor.getType(object);
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("createNodeFromTokenElements\t");
        stringBuffer.append(n);
        stringBuffer.append("\t");
        stringBuffer.append(n2);
        this.serializeText(stringBuffer, string);
        this.transmit(stringBuffer.toString());
    }

    public void createNode(Object object, Token token) {
        int n = this.adaptor.getUniqueID(object);
        int n2 = token.getTokenIndex();
        this.transmit("createNode\t" + n + "\t" + n2);
    }

    public void becomeRoot(Object object, Object object2) {
        int n = this.adaptor.getUniqueID(object);
        int n2 = this.adaptor.getUniqueID(object2);
        this.transmit("becomeRoot\t" + n + "\t" + n2);
    }

    public void addChild(Object object, Object object2) {
        int n = this.adaptor.getUniqueID(object);
        int n2 = this.adaptor.getUniqueID(object2);
        this.transmit("addChild\t" + n + "\t" + n2);
    }

    public void setTokenBoundaries(Object object, int n, int n2) {
        int n3 = this.adaptor.getUniqueID(object);
        this.transmit("setTokenBoundaries\t" + n3 + "\t" + n + "\t" + n2);
    }

    public void setTreeAdaptor(TreeAdaptor treeAdaptor) {
        this.adaptor = treeAdaptor;
    }

    public TreeAdaptor getTreeAdaptor() {
        return this.adaptor;
    }

    protected String serializeToken(Token token) {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append(token.getTokenIndex());
        stringBuffer.append('\t');
        stringBuffer.append(token.getType());
        stringBuffer.append('\t');
        stringBuffer.append(token.getChannel());
        stringBuffer.append('\t');
        stringBuffer.append(token.getLine());
        stringBuffer.append('\t');
        stringBuffer.append(token.getCharPositionInLine());
        this.serializeText(stringBuffer, token.getText());
        return stringBuffer.toString();
    }

    protected void serializeText(StringBuffer stringBuffer, String string) {
        stringBuffer.append("\t\"");
        if (string == null) {
            string = "";
        }
        string = this.escapeNewlines(string);
        stringBuffer.append(string);
    }

    protected String escapeNewlines(String string) {
        string = string.replaceAll("%", "%25");
        string = string.replaceAll("\n", "%0A");
        string = string.replaceAll("\r", "%0D");
        return string;
    }
}

